% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_data.r
\docType{data}
\name{PimaIndiansDiabetes_wide}
\alias{PimaIndiansDiabetes_wide}
\title{Pima Indians Diabetes Dataset, wide}
\format{
A data frame with 392 observations of
8 numeric variables, and target factor \code{diabetes}.
\itemize{
\item pregnant, Number of times pregnant
\item glucose, Plasma glucose concentration (glucose tolerance test)
\item pressure, Diastolic blood pressure (mm Hg)
\item triceps, Triceps skin fold thickness (mm)
\item insulin, 2-Hour serum insulin (mu U/ml)
\item mass, Body mass index (weight in kg/(height in m)\^2)
\item pedigree, Diabetes pedigree function
\item age, Age (years)
\item diabetes, Class variable (test for diabetes), either "pos" or "neg"
}
}
\usage{
PimaIndiansDiabetes_wide
}
\description{
The data set PimaIndiansDiabetes2 contains a corrected version of the
original data set. While the UCI repository index claims that there are no
missing values, closer inspection of the data shows several physical
impossibilities, e.g., blood pressure or body mass index of 0. In
PimaIndiansDiabetes2, all zero values of glucose, pressure, triceps, insulin
and mass have been set to NA, see also Wahba et al (1995) and Ripley (1996).
}
\details{
This is a cleaned subset of \code{mlbench}'s \code{PimaIndiansDiabetes2}.
See \code{help(PimaIndiansDiabetes2, package = "mlbench")}.

Replicating this dataset:\preformatted{require("mlbench")
data(PimaIndiansDiabetes2)

d <- PimaIndiansDiabetes2
d <- d[complete.cases(d), ] ## Remove ~350 row-wise incomplete rows
PimaIndiansDiabetes_wide <- d
## save(PimaIndiansDiabetes_wide, file = "./data/PimaIndiansDiabetes_wide.rda")
}
}
\examples{
library("spinifex")
str(PimaIndiansDiabetes_wide)
dat <- scale_sd(PimaIndiansDiabetes_wide[, 1:8])
clas <- PimaIndiansDiabetes_wide$diabetes

bas <- basis_pca(dat)
mv <- manip_var_of(bas)
mt <- manual_tour(bas, mv)

ggt <- ggtour(mt, dat, angle = .2) +
  proto_default(aes_args = list(color = clas, shape = clas))
\dontrun{
animate_plotly(ggt)}
}
\keyword{datasets}
