% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idwpred.R
\name{idwpred}
\alias{idwpred}
\title{Generate spatial predictions using inverse distance weighting (IDW)}
\usage{
idwpred(longlat, trainy, longlat2, nmax = 12, idp = 2, ...)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of samples.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in longlat.}

\item{longlat2}{a dataframe contains longitude and latitude of point locations
(i.e., the centres of grids) to be predicted.}

\item{nmax}{for a local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used.}

\item{idp}{numeric; specify the inverse distance weighting power.}

\item{...}{other arguments passed on to gstat.}
}
\value{
A dataframe of longitude, latitude and predictions.
}
\description{
This function is to make spatial predictions using inverse
distance weighting.
}
\note{
This function is largely based on library(gstat).
}
\examples{
\dontrun{
library(sp)
data(swmud)
data(sw)
idwpred1 <- idwpred(swmud[, c(1,2)], swmud[, 3], sw, nmax = 12, idp = 2)
names(idwpred1)
}

}
\references{
Pebesma, E.J., 2004. Multivariable geostatistics in S: the gstat
package. Computers & Geosciences, 30: 683-691.
}
\author{
Jin Li
}
