% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.spmod}
\alias{coef.spmod}
\alias{coefficients.spmod}
\title{Extract fitted model coefficients}
\usage{
\method{coef}{spmod}(object, type = "fixed", ...)

\method{coefficients}{spmod}(object, type = "fixed", ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{type}{\code{"fixed"} for fixed effect coefficients, \code{"spcov"} for
spatial covariance parameter coefficients, or \code{"randcov"} for random effect
variance coefficients. Defaults to \code{"fixed"}. If \code{type = "spcov"}, the
coefficient vector is an \code{\link[=spcov_params]{spcov_params()}} object (which means that has class
matching the spatial covariance function used).}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A named vector of coefficients.
}
\description{
coef extracts fitted model coefficients from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}
fitted model objects. \code{coefficients} is an alias for it.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
coef(spmod)
coefficients(spmod)
coef(spmod, type = "spcov")
}
