% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\name{htmlToken}
\alias{htmlToken}
\title{Process Html Token}
\usage{
htmlToken(
  x,
  token_open = getOption("html_token_open", ""),
  token_close = getOption("html_token_close", ""),
  math_open = getOption("html_math_open", ""),
  math_close = getOption("html_math_close", ""),
  label_open = getOption("html_label_open", ""),
  label_close = getOption("html_label_close", ""),
  ...
)
}
\arguments{
\item{x}{character}

\item{token_open, token_close}{these wrap the entire token (used once); by default the token is text-like}

\item{math_open, math_close}{these wrap math-like portions of the token;  the defaults try to give upright characters (non-italic) which may not work for Greek symbols}

\item{label_open, label_close}{these re-wrap math-like portions of the token}

\item{...}{ignored arguments}
}
\value{
html
}
\description{
Pre-processes a html token not recognized as
spork.  Escapes the common names for Greek letters
and escapes html metacharacters.
}
\examples{
htmlToken('foo')
htmlToken('alpha')
htmlToken('Alpha')
}
\seealso{
Other html: 
\code{\link{[.html}()},
\code{\link{[[.html}()},
\code{\link{as_html.spar}()},
\code{\link{as_html.spork}()},
\code{\link{as_html}()}

Other interface: 
\code{\link{as.expression.plotmath}()},
\code{\link{as_html.spar}()},
\code{\link{as_html.spork}()},
\code{\link{as_latex.spar}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spar}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_previews.spork}()},
\code{\link{as_spork.character}()},
\code{\link{latexToken}()},
\code{\link{plotmathToken}()}
}
\concept{html}
\concept{interface}
