% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit-conversions.R
\name{convert_units}
\alias{convert_units}
\title{Convert all units, regardless of starting and ending units}
\usage{
convert_units(meas, from_unit, to_unit, conversion_columns = NULL)
}
\arguments{
\item{meas}{A measurement in any unit of length}

\item{from_unit}{A string containing the original unit of measure to be
converted}

\item{to_unit}{A string containing the ending unit of measure}

\item{conversion_columns}{A vector containing the columns to convert if
\code{meas} is of type \code{data.frame}}
}
\value{
The measurement in converted units
}
\description{
Convert all units, regardless of starting and ending units
}
\examples{
convert_units(1, "in", "cm")
convert_units(100, "cm", "m")
}
