% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{LoadData}
\alias{LoadData}
\title{Load selected data}
\usage{
LoadData(file.path, data.use = c("Visium.HNN", "Visium.Brain"))
}
\arguments{
\item{file.path}{Path to the directory contains or to download the data object, i.e. "~/Downloads".}

\item{data.use}{Selected data to load. See \code{\link[spots]{available.data}}.
\itemize{
\item Visium.HNN, hexagonal nearest neighbor distance matrix of
\href{https://www.10xgenomics.com/spatial-transcriptomics}{10x Visium} 4992 whitelist spatial barcodes.
\item Visium.Brain, sample \href{https://www.10xgenomics.com/resources/datasets/mouse-brain-serial-section-1-sagittal-posterior-1-standard-1-0-0}{10x Visium Sagittal-Posterior Mouse Brain}
data with 3353 spatial barcodes and 2000 highly variable genes, load as a \href{https://satijalab.org/seurat/articles/spatial_vignette.html}{Seurat object}.
}}
}
\value{
Selected data:
}
\description{
If not previously run, it will download the selected data.
}
\examples{
\dontrun{
Visium.hnn.dist <- LoadData("~/Downloads", "Visium.HNN")
}

}
\concept{data}
