% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sca.R
\name{SpatialXCorr}
\alias{SpatialXCorr}
\title{Spatial cross-correlation}
\usage{
SpatialXCorr(X, W, method = c("M", "L"))
}
\arguments{
\item{X}{A matrix with observations as rows and features as columns.}

\item{W}{A weight matrix across all observations, i.e inverse of a pairwise distance matrix.}

\item{method}{Method used to calculate spatial cross-correlation.
\itemize{
\item M, using the Wartenburg's M (Default).
\item L, using the Lee's L.
}}
}
\value{
A spatial cross-correlation matrix.
}
\description{
Calculate spatial cross-correlation matrix.
}
\examples{
{
data.use <- quakes[1:100,]
W <- 1/as.matrix(dist(data.use[,1:2]))
diag(W) <- 0
M <- SpatialXCorr(data.use[,3:4], W, method = "M")
L <- SpatialXCorr(data.use[,3:4], W, method = "L")
}
}
\references{
Wartenberg, D. Multivariate spatial correlation:
A method for exploratory geographical analysis. Geogr. Anal. 17, 263–283 (1985)

Lee, S.-I. Developing a bivariate spatial association measure:
An integration of Pearson’s r and Moran's I. J. Geogr. Syst. 3, 369–385 (2001)
}
\seealso{
\code{\link[spots]{WartenbergM}} \code{\link[spots]{LeeL}}.
}
\concept{sca}
