% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postgen_ops.R
\name{GetMAPLabels}
\alias{GetMAPLabels}
\title{Retrieve the MAP estimates for the component labels}
\usage{
GetMAPLabels(fit)
}
\arguments{
\item{fit}{Object of class \code{damcmc_res} or \code{bdmcmc_res}.}
}
\value{
A vector with size equal to the number of points, containing
the MAP estimators of the component labels (or
membership indicator variables). This the most likely
component we would classify a point in.
}
\description{
The function returns the Maximum A Posteriori (MAP)
estimates of the component labels (membership indicator variables)
based on a \code{damcmc_res} object (output from \code{\link{est_mix_damcmc}}) or
a \code{bdmcmc_res} object (output from \code{\link{est_mix_bdmcmc}}) for the
chain corresponding to MAP number of components.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#GetMAPLabels}
}
\examples{

\dontrun{
truemix <- normmix(ps=c(.4, .2,.4), mus=list(c(0.3, 0.3), c(.5,.5),c(0.7, 0.7)),
 sigmas = list(.02*diag(2), .05*diag(2), .01*diag(2)))
intsurf=to_int_surf(truemix,lambda = 100, win = spatstat::square(1))
pp1 <- rsppmix(intsurf)
plot(pp1)
plot(pp1, mus = intsurf$mus)#plot the mixture means as well
#plot the points with different colors depending on the true component label
plot(pp1, colors = TRUE)
#plot the points with different colors depending on the estimated component label
fit <- est_mix_damcmc(pp1, 3)
est_comp <- GetMAPLabels(fit)
plot(pp1, estcomp = est_comp, colors = TRUE)
fitBD <- est_mix_bdmcmc(pp1, 5)
est_compBD <- GetMAPLabels(fitBD)
plot(pp1, estcomp = est_compBD, colors = TRUE)}

}
\author{
Jiaxun Chen
}
\seealso{
\code{\link{normmix}},
\code{\link{to_int_surf}},
\code{\link{rsppmix}},
\code{\link{est_mix_damcmc}}
}

