% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix_plots.R
\name{plotmix_2d}
\alias{plotmix_2d}
\title{2d exploratory plots for mixture intensity surfaces}
\usage{
plotmix_2d(intsurf, pattern, estcomp, contour = FALSE, truncate = TRUE,
  L = 256, open_new_window = FALSE, grayscale = FALSE, colors = FALSE,
  ...)
}
\arguments{
\item{intsurf}{Object of class \code{intensity_surface} or \code{normmix}.}

\item{pattern}{Optional spatial point pattern
to add to the plot. This is an object of
class \code{\link[spatstat]{ppp}}.}

\item{estcomp}{The estimated component label should be a vector whose length
should be the same as number of points. If \code{estcomp} is not missing, the function will plot the
points using different colors according to \code{estcomp}. See the example on how
to calculate \code{estcomp} from a DAMCMC fit. If this variable is missing and we
pass a point pattern generated using \code{rsppmix}, then the true component labels will be used, otherwise,
the function will not plot the points with different colors to indicate the different components.}

\item{contour}{Logical flag requesting the countour plot only.}

\item{truncate}{Logical variable indicating that the points should be
within the window of observation. Default is TRUE.}

\item{L}{Length of the side of the square grid.
The intensity is calculated on an L * L grid.
The larger this value is, the better the picture resolution.}

\item{open_new_window}{Open a new window for the plot.}

\item{grayscale}{Plot in gray scale. Default is FALSE (use colors).}

\item{colors}{Logical flag requesting to use different colors for the points based
on which component they belong to.}

\item{...}{Additional parameters passed to \code{to_int_surf()}.}
}
\description{
Create a 2d image or contour plot of the
intensity surface, with the option to display
a point pattern.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plotmix_2d}
}
\examples{

\dontrun{
# plot normmix density
truemix<- rnormmix(m = 3, sig0 = .1, df = 5, xlim= c(0, 5), ylim = c(0, 5))
summary(truemix)
intsurf=to_int_surf(truemix, lambda = 100, win =spatstat::owin( c(0, 5),c(0, 5)))
#plot the intensity surface
plotmix_2d(intsurf)
plotmix_2d(intsurf,contour = TRUE)
pp1 <- rsppmix(intsurf = intsurf)# draw points
plotmix_2d(intsurf, pp1)
plotmix_2d(intsurf, pp1,contour = TRUE)
#fit a Poisson with mixture intensity surface
CAgens=est_mix_damcmc(pp = CAQuakes2014.RichterOver3.0, m = 5)
#retrieve the surface of posterior means
CAfit=GetPMEst(CAgens)
#plot the surface and the point pattern
plotmix_2d(CAfit,CAQuakes2014.RichterOver3.0)
#to include the state boundaries use function PlotUSAStates
ret=PlotUSAStates(states=c('California','Nevada','Arizona'), showcentroids=FALSE,
 shownames=TRUE, main="Earthquakes in CA, 2014", pp=CAQuakes2014.RichterOver3.0,
 surf=CAfit, boundarycolor="white", namescolor="white")
#plotting the points with different colors depending on the component they belong to
truemix <- rnormmix(m = 5, sig0 = .1, df = 5, xlim=c(-2,2), ylim=c(-2,2))
intsurf=to_int_surf(truemix, lambda = 100, win = spatstat::owin(c(-2,2),c(-2,2)))
pp1 <- rsppmix(intsurf)
#plot the points with different colors depending on the true component label
plotmix_2d(intsurf,pp1, colors = TRUE)
#plot the points with different colors depending on the estimated component label
fit <- est_mix_damcmc(pp1, 5)
est_comp <- GetMAPLabels(fit)
plotmix_2d(intsurf,pp1, estcomp = est_comp, colors = TRUE)
plotmix_2d(intsurf,pp1, estcomp = est_comp, contour = TRUE,colors = TRUE)}

}
\author{
Jiaxun Chen, Sakis Micheas, Yuchen Wang
}
\seealso{
\code{\link{normmix}},
\code{\link{to_int_surf}},
\code{\link[spatstat]{owin}},
\code{\link{rsppmix}},
\code{\link{GetMAPLabels}},
\code{\link{est_mix_damcmc}},
\code{\link{PlotUSAStates}}
}

