% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postgen_ops.R
\name{GetBDTable}
\alias{GetBDTable}
\title{Retrieve the MAP and distribution of the number of components}
\usage{
GetBDTable(BDfit, showtable = TRUE)
}
\arguments{
\item{BDfit}{A BDMCMC fit obtain from \code{\link{est_mix_bdmcmc}}.}

\item{showtable}{Logical variable requesting to display the frequency table. Default is TRUE.}
}
\value{
A list containing the following:
 \item{MAPcomp}{The MAP number of mixture components.}
 \item{FreqTab}{Frequency table for the number of components.}
 \item{MeanComp}{The posterior mean for the number of components.}
}
\description{
The function can be used to obtain the MAP estimate (mode of the posterior)
along with the frequency table for the
number of components, based on a BDMCMC fit from \code{\link{est_mix_bdmcmc}}.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#GetBDTable}
}
\examples{
\donttest{
fit <- est_mix_bdmcmc(pp = spatstat::redwood, m = 7)
GetBDTable(fit)}

}
\seealso{
\code{\link{est_mix_bdmcmc}}
}
\author{
Sakis Micheas
}
