% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kstest2d.R
\name{kstest2d}
\alias{kstest2d}
\title{Nonparametric Goodness-of-fit test between two point patterns}
\usage{
kstest2d(x1, x2, showinfo = TRUE)
}
\arguments{
\item{x1, x2}{Objects of class \code{\link[spatstat]{ppp}}.}

\item{showinfo}{Logical variable. Requests to display the test conclusion based on the value of the p-value. Default is TRUE.}
}
\value{
A list with class "htest" containing the following components:
\item{statistic}{Value of the KS statistic}
\item{p.value}{The p-value of the test}
\item{alternative}{A character string describing the alternative hypothesis}
}
\description{
This function performs a two-dimensional Kolmogorov-Smirnov goodness-of-fit
test on two point patterns.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#kstest2d}
}
\examples{
\donttest{
# generate two point patterns
mix1 <- rnormmix(3, sig0 = .01, df = 5, xlim=c(0, 5), ylim=c(0, 5))
intsurf1=to_int_surf(mix1,lambda = 40, win =spatstat::owin( c(0, 5),c(0, 5)))
mix2 <- rnormmix(8, sig0 = .01, df = 10, xlim=c(0, 5),ylim=c(0, 5))
intsurf2=to_int_surf(mix2,lambda = 50, win =spatstat::owin( c(0, 5),c(0, 5)))
#generate patterns from the two different models
pp1 <- rsppmix(intsurf1)
pp2 <- rsppmix(intsurf2)
pp3 <- rsppmix(intsurf2)#pp3 is from the same model as pp2
# Test for goodness of fit, p-value should be small
kstest2d(pp1, pp2)
# Test for goodness of fit, p-value should be large
kstest2d(pp2, pp3)}

}
\references{
Peacock, J.A. (1983). Two-dimensional goodness-of-fit testing in
astronomy. Monthly Notices Royal Astronomy Society, 202, 615-627.

Adapted from Matlab code by Dylan Muir.
}
\seealso{
\code{\link{rnormmix}},\code{\link{to_int_surf}},\code{\link[spatstat]{owin}}
}
\author{
Jiaxun Chen, Sakis Micheas
}
