% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_spruce.R
\name{fit_spruce}
\alias{fit_spruce}
\title{Fit spruce Bayesian spatial mixture model}
\usage{
fit_spruce(
  seurat_obj,
  K,
  emb = "PCs",
  n_dim = 8,
  r = 3,
  MCAR = TRUE,
  CAR = TRUE,
  smooth = TRUE,
  nsim = 2000,
  burn = 1000,
  z_init = NULL
)
}
\arguments{
\item{seurat_obj}{An integrated Seurat object}

\item{K}{The number of sub-populations to infer. Each should be present in each sample.}

\item{emb}{Either one of "PCs", "HVGs", or "SVGs" OR a matrix with custom embeddings. If the latter, rows should be sorted as in meta data of Seurat object.}

\item{n_dim}{The number of dimensions to use if emb is specified as one of "PCs", "HVGs", or "SVGs". Ignored if emb is a matrix of custom embeddings.}

\item{r}{Spatial smoothing parameter. Should be greater than 0 with larger values enforcing stronger prior spatial association.}

\item{MCAR}{Logical. Include multivariate CAR random intercepts in gene expression model?}

\item{CAR}{Logical. Include univariate CAR random intercepts in multinomial gene expression model?}

\item{smooth}{Logical. Use manual spatial smoothing controled by r parameter?}

\item{nsim}{Number of total MCMC iterations to conduct.}

\item{burn}{Number of initial MCMC iterations to discard as burn in. The number of saved iterations is nsim-burn}

\item{z_init}{Initialized cluster allocation vector to aid in MCMC convergence. If NULL z_init will be set using hierarchical clustering.}
}
\value{
A list of MCMC samples, including the MAP estimate of cluster indicators (z)
}
\description{
This function allows you to detect sub-populations single-sample spatial transcriptomics experiments.
}
\keyword{Bayesian}
\keyword{spatial}
\keyword{transcriptomics}
