% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pg_pane.R
\name{pgPaneUI}
\alias{pgPaneUI}
\alias{pgPaneUpdate}
\title{A draggable progress panel}
\usage{
pgPaneUI(
  pane_id,
  titles,
  pg_ids,
  title_main = NULL,
  opened = FALSE,
  top = "3\%",
  right = "2\%"
)

pgPaneUpdate(pane_id, pg_id, value, session = getDefaultReactiveDomain())
}
\arguments{
\item{pane_id}{Progress panel main ID, use \code{ns} wrap it on \code{pgPaneUI} but not
on \code{pgPaneUpdate} if using shiny module}

\item{titles}{labels to display for each progress, must have the same length
as \code{pg_ids}}

\item{pg_ids}{a character vector of IDs for each progress. Don't forget
to use \code{ns} wrap each ID.}

\item{title_main}{If not specified and pane_id contains 'plot', title will be
'Plot Prepare'; has 'df' will be 'Data Prepare', if neither will be
"Progress"}

\item{opened}{bool, if this panel is opened at start}

\item{top}{css style off set to the current windown top}

\item{right}{css style off set to the current windown right}

\item{pg_id}{a character string of ID indicating which progress within this
panel you want to update.
Do not use \code{ns(pg_id)} to wrap it on server}

\item{value}{0-100 number to update the progress you use \code{pg_id} to
choose}

\item{session}{current shiny session}
}
\value{
HTML elements
}
\description{
Creates a panel that displays multiple progress items.
Use \link{pgPaneUI} on UI side and use \code{pgPaneUpdate} to update it.

A overall progress is automatically calculated on the bottom.
}
\examples{
if(interactive()){
    # try to slide c under 0
    ui <- fluidPage(
        h4("you need to open up the progress
                                tracker, it is collapsed ->"),
        actionButton("a", "a"),
        actionButton("b", "b"),
        sliderInput("c", min = -100,
                    max = 100, value = 0,
                    label = "c"),
        pgPaneUI(
            pane_id = "thispg",
            titles = c("this a", "this b", " this c"),
            pg_ids = c("a", "b", "c"),
            title_main = "Example Progress",
            opened = TRUE,
            top = "30\%",
            right = "50\%"
        )

    )
    server <- function(input, output, session) {
        observeEvent(input$a, {
            for(i in 1:10){
                pgPaneUpdate("thispg", "a", i*10)
                Sys.sleep(0.3)
            }
        })
        observeEvent(input$b, {
            for(i in 1:10){
                pgPaneUpdate("thispg", "b", i*10)
                Sys.sleep(0.3)
            }
        })
        observeEvent(input$c, pgPaneUpdate("thispg", "c", input$c))
    }
    shinyApp(ui, server)
}
}
