% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLikFun.norm.R
\name{logLikFun.norm}
\alias{logLikFun.norm}
\title{Calculation of the Log-likelihood assuming Identially, Independenzly and Normally Distributed errors}
\usage{
logLikFun.norm(y, yhat, sigma)
}
\arguments{
\item{y}{A vector of \code{n} observed properties/variables of interest.}

\item{yhat}{A vector of \code{n} model simulated properties/variables of interest.}

\item{sigma}{A vector of length 1 considering homoscedastic residuals.}
}
\value{
\emph{log-likelihood} value of an normal distribution with N~(0, \emph{sigma^2})
}
\description{
Calculates the i-th log-likelihood of each \emph{y-yhat} pair as described in \insertCite{Seber.2004}{spsh}.
}
\details{
The underlying assumption is, that the model residuals (errors) are independently, and identically distributed (i.i.d.) following a normal distribution.
Alternatively consider using \link[=base]{dnorm}.
}
\note{
The assumption of i.i.d. and normal distribution is best investigated \emph{a posteriori}.
}
\examples{
# homoscedastic residuals
sig.s  <- .01
y.scat <- rnorm(100, 0, sig.s)
yhat   <- (1:100)^1.2
y      <- yhat + y.scat
sum(logLikFun.norm(y, yhat, sig.s))
plot(yhat-y)
}
\references{
\insertRef{Seber.2004}{spsh}
}
\author{
Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
