% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppd_plot.R
\name{ppd_plot}
\alias{ppd_plot}
\title{Plot power curves for panel designs}
\usage{
ppd_plot(
  object,
  plot_type = "standard",
  trend_type = "mean",
  xaxis_type = "period",
  comp_type = "design",
  dsgns = NULL,
  indicator = NULL,
  trend = NULL,
  period = NULL,
  alpha = NULL,
  ...
)
}
\arguments{
\item{object}{List object of class \code{powerpaneldesign}. Object provides
power calculated for a set of panel designs, set of indicators, set of
trend values, and set of alpha values. Expect input as list as output from
function \code{power_dsgn}.}

\item{plot_type}{Default is \code{"standard"} which plots standard power curve. If
equal to \code{"relative"}, then plot power of one panel design compared to one or
more other panel designs.}

\item{trend_type}{Character value for trend in mean (\code{"mean"}) or or percent
change in proportion (\code{"percent"}) of cumulative distribution function above
or below a fixed cut point.  Default is \code{"mean"}.}

\item{xaxis_type}{Character value equal to \code{"period"} or \code{"change"} which
designates the type of x-axis for power plot where power is plotted on
y-axis.  For \code{xaxis_type = "period"}, x-axis is periods in \code{dsgnpower}. If
\code{xaxis_type = "change"}, then x-axis is percent per period with secondary
x-axes for total percent per period and associated change in mean.
Default is \code{"period"}.  Note that \code{xaxis_type} controls how the input for
\code{"period"} and \code{"trend"} parameters is used.}

\item{comp_type}{Character value equal to \code{"design"} or \code{"indicator"} which
designates the type of power curve comparison that will occur on a single
plot.  If \code{comp_type = "design"}, then on a single plot of power curves all
panel designs specified in \code{"dsgns"} are plotted for a single indicator,
single trend value and single alpha.  If \code{comp_type = "indicator"}, then on a
single plot of power curves all indicators specified in \code{"indicator"} are
plotted for a single panel design, single trend value and single alpha.
Default is \code{"design"}.}

\item{dsgns}{Vector of names of panel designs that are to be plotted.  Names
must be all, or a subset of, names of designs in \code{dsgnpower}. Default is \code{NULL}
which results in only the first panel design in \code{dsgnpower} being used.}

\item{indicator}{Vector of indicator names contained in \code{dsgnpower} that are
to be plotted.  Indicator names must be all, or a subset of, indicator
names in \code{dsgnpower}. Default is \code{NULL} which results in only the first
indicator in \code{dsgnpower} being used.}

\item{trend}{\code{NULL}. A single value or vector of values contained in \code{dsgnpower}
that will be plotted. Values must be all, or a subset of, trend values in
\code{dsgnpower}. If \code{xaxis_type} is equal to \code{"period"}, then \code{NULL} results in maximum
trend value being used and a single value or vector of values results in a
separate plot for each value specified.  If \code{xaxis_type} is equal to
\code{"change"}, then \code{NULL} results in all trend values in \code{dsgnpower} being plotted
on x-axis and a vector of values results in all trend values in \code{dsgnpower}
from minimum value to maximum value specified being plotted on x-axis.}

\item{period}{\code{NULL}, a single value or vector of values contained in \code{dsgnpower}
that will be plotted. Values must be all, or a subset of, period values in
\code{dsgnpower}. If \code{xaxis_type} is equal to \code{"period"}, then \code{NULL} results in all
time periods in \code{dsgnpower} being plotted on x-axis and a vector of values
results in all period values in \code{dsgnpower} from minimum value to maximum
value specified being plotted on x-axis. If \code{xaxis_type} is equal to
\code{"change"}, then \code{NULL} results in all time periods in \code{dsgnpower} being plotted
in separate plots and a vector of values results in time periods specified
being plotted in separate plots.}

\item{alpha}{A single value or vector of significance levels (as proportion,
e.g. \code{0.05}) contained in \code{dsgnpower} to used for power plots. Specifying more
than a single value results in multiple plots. Default is \code{NULL} which
results in the minimum significance level in \code{dsgnpower} being used.}

\item{...}{Additional arguments (S3 consistency)}
}
\value{
One or more power curve plots are created and plotted.  User must
  specify output graphical device if more than one plot is created.  See
  Devices for graphical output options.
}
\description{
Plot power curves and relative power curves for trend detection for set of
panel designs, time periods, indicators, significance levels and trend.  Trend
may be based on percent change per period in mean or percent change in
proportion of cumulative distribution function above or below a fixed cut
point. Types of plots are combinations of standard/relative, mean/percent,
period/change and design/indicator.  Input must be be of class
powerpaneldesign and is normally the output of function power_dsgn.
}
\details{
By default the plot function produces a standard power curve at end
  of each time period on the x-axis with y-axis as power. When more than one
  panel design is in \code{dsgnpower}, the first panel design is used. When more than
  one indicator is in \code{dsgnpower}, the first indicator is used.  When more than
  one trend value is in \code{dsgnpower}, the maximum trend value is used. When more
  than one significance level, \code{alpha}, is in \code{dsgnpower}, the minimum
  significance level is used.

  Control of the type of plot produced is governed by \code{plot_type}, \code{trend_type},
  \code{xaxis_type} and \code{comp_type}. The number of plots produced is governed by the
  number of panel designs (\code{dsgn}) specified, the number of indicators
  (\code{indicator}) specified, the number of time periods (\code{period}) specifies, the
  number of trend values (trend) specified and the number of significance
  levels (\code{alpha}) specified.

  When the comparison type (\code{"comp_type"}) is equal to \code{"design"}, all power
  curves specified by dsgn are plotted on the same plot.  When \code{comp_type} is
  equal to \code{"indicator"}, all power curves specified by \code{"indicator"} are plotted
  on the same plot.  Typically, no more than 4-5 power curves should be
  plotted on same plot.
}
\examples{
# Construct a rotating panel design with sample size of 60
R60N <- revisit_dsgn(20, panels = list(R60N = list(
  n = 60, pnl_dsgn = c(1, NA),
  pnl_n = NA, start_option = "None"
)), begin = 1)

# Construct a fixed panel design with sample size of 60
F60 <- revisit_dsgn(20, panels = list(F60 = list(
  n = 60, pnl_dsgn = c(1, 0),
  pnl_n = NA, start_option = "None"
)), begin = 1)

# Power for rotating panel with sample size 60
Power_tst <- power_dsgn("Variable_Name",
  ind_values = 43, unit_var = 280,
  period_var = 4, unitperiod_var = 40, index_var = 90,
  unit_rho = 1, period_rho = 0, paneldsgn = list(
    R60N = R60N, F60 = F60
  ), nrepeats = NULL,
  trend_type = "mean", trend = c(1.0, 2.0), alpha = 0.05
)
ppd_plot(Power_tst)
ppd_plot(Power_tst, dsgns = c("F60", "R60N"))
ppd_plot(Power_tst, dsgns = c("F60", "R60N"), trend = 1.0)
ppd_plot(Power_tst,
  plot_type = "relative", comp_type = "design",
  trend_type = "mean", trend = c(1, 2), dsgns = c("R60N", "F60"),
  indicator = "Variable_Name"
)
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
