% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_player_recent_.R
\name{get_player_recent_results}
\alias{get_player_recent_results}
\title{Get a player's recent event results from SquashInfo}
\usage{
get_player_recent_results(player = NULL, rank = NULL, category = NULL)
}
\arguments{
\item{player}{character string of player name.}

\item{rank}{single integer or vector of integers indicating the rank of the PSA player(s) to return.}

\item{category}{character string indicating the competition category. Must be one of "both", "mens", or "womens".}
}
\value{
Tibble containing the player rank, player name, player's seeding, round reached, event name, event date, event location, and event tour.
}
\description{
Given the full name or rank of a player and the competition category, \code{get_player_recent_results()} returns the recent event results table for PSA ranked players.
}
\note{
This function only returns results data from players ranked in the most recent PSA rankings table for Men's and Women's singles competitions. Recent results are limited to events that occurred within the current and previous calendar years.
}
\examples{

## Get Mohamed Elshorbagy's most recent results data
\donttest{get_player_recent_results(player = "Mohamed Elshorbagy", category = "mens")}

## Get Nour El Tayeb's recent results data
\donttest{get_player_recent_results("El Tayeb", category = "womens")}

## Get recent results data from the top two players in both Men's and Women's competitions
\donttest{get_player_recent_results(rank = 1:2, category = "both")}

}
\references{
\url{http://www.squashinfo.com/}
}
