% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey_statistics.r
\name{survey_quantile}
\alias{survey_quantile}
\alias{survey_median}
\title{Calculate the quantile and its variation using survey methods}
\usage{
survey_quantile(
  x,
  quantiles,
  na.rm = FALSE,
  vartype = c("se", "ci", "var", "cv"),
  level = 0.95,
  interval_type = c("mean", "beta", "xlogit", "asin", "score", "quantile"),
  qrule = c("math", "school", "shahvaish", "hf1", "hf2", "hf3", "hf4", "hf5", "hf6",
    "hf7", "hf8", "hf9"),
  df = NULL,
  ...
)

survey_median(
  x,
  na.rm = FALSE,
  vartype = c("se", "ci", "var", "cv"),
  level = 0.95,
  interval_type = c("mean", "beta", "xlogit", "asin", "score", "quantile"),
  qrule = c("math", "school", "shahvaish", "hf1", "hf2", "hf3", "hf4", "hf5", "hf6",
    "hf7", "hf8", "hf9"),
  df = NULL,
  ...
)
}
\arguments{
\item{x}{A variable or expression}

\item{quantiles}{A vector of quantiles to calculate}

\item{na.rm}{A logical value to indicate whether missing values should be dropped}

\item{vartype}{NULL to report no variability. Otherwise one or more of: standard error ("se", the default),
confidence interval ("ci"), variance ("var") or coefficient of variation
("cv").}

\item{level}{A single number indicating the confidence level (only one level allowed). Note that this may effect estimated standard errors (see \code{\link[survey]{svyquantile}} details on \code{alpha}, which equals \code{1-level}).}

\item{interval_type}{See \code{\link[survey]{svyquantile}}. Note that \code{interval_type = "quantile"} is only available for replicate designs, and \code{interval_type = "score"} is unavailable for replicate designs.}

\item{qrule}{See \code{\link[survey]{svyquantile}}}

\item{df}{A number indicating the degrees of freedom for t-distribution. The
default, NULL, uses the design degrees of freedom (matches the survey package).}

\item{...}{Ignored}
}
\description{
Calculate quantiles from complex survey data. A wrapper
around \code{\link[survey]{svyquantile}}. \code{survey_quantile} and
\code{survey_median} should always be called from \code{\link{summarise}}.
}
\details{
Note that the behavior of these functions has changed in srvyr version 1.1,
but the old functions are still (currently) supported as
\code{\link{survey_old_quantile}} and \code{survey_old_median} if you need
to replicate the old results. For more details about what has changed, see
Thomas Lumley's blog post on the changes, available here:
<https://notstatschat.rbind.io/2021/07/20/what-s-new-in-the-survey-package/>
}
\examples{
library(survey)
data(api)

dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw)

dstrata \%>\%
  summarise(api99 = survey_quantile(api99, c(0.25, 0.5, 0.75)),
            api00 = survey_median(api00, vartype = c("ci")))

dstrata \%>\%
  group_by(awards) \%>\%
  summarise(api00 = survey_median(api00))

}
