% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssMRCD_methods.R
\name{scale_ssMRCD}
\alias{scale_ssMRCD}
\title{Scale Data Locally}
\usage{
scale_ssMRCD(
  ssMRCD,
  X = NULL,
  groups = NULL,
  multivariate = FALSE,
  center_only = FALSE
)
}
\arguments{
\item{ssMRCD}{\code{ssMRCD} object, see \code{\link[ssMRCD]{ssMRCD}}}

\item{X}{matrix, new data to scale with ssMRCD estimation.}

\item{groups}{vector, group assignments of new data \code{X}.}

\item{multivariate}{logical, \code{TRUE} if multivariate structure should be used.
Otherwise, univariate variances from the ssMRCD estimator is used.}

\item{center_only}{logical, if \code{TRUE} observations are only centered.}
}
\value{
Returns matrix of observations. If \code{X = NULL} X from the ssMRCD object is
used and sorted according to group numbering.
}
\description{
Scale Data Locally
}
\examples{
# create data set
x1 = matrix(runif(200), ncol = 2)
x2 = matrix(rnorm(200), ncol = 2)
x = list(x1, x2)

# create weighting matrix
W = matrix(c(0, 1, 1, 0), ncol = 2)

# calculate ssMRCD
localCovs = ssMRCD(x, weights = W, lambda = 0.5)

# scale used data
scale_ssMRCD(localCovs,
      multivariate = TRUE)

# scale new data
scale_ssMRCD(localCovs,
      X = matrix(rnorm(20), ncol = 2, nrow = 10),
      groups = rep(2, 10),
      multivariate =TRUE)
}
\seealso{
\code{\link[ssMRCD]{ssMRCD}}
}
