% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nfsdr.R
\name{nfsdr}
\alias{nfsdr}
\title{Nonparametric false simultaneous discovery rate control}
\usage{
nfsdr(T, alpha, rho = 0, m = 5000, rescale = TRUE)
}
\arguments{
\item{T}{n x D matrix of test statistics that are stochastically larger under the null, where n is the number of features and D is the numberof sequences of test statistics}

\item{alpha}{nominal false simultaneous discovery rate}

\item{rho}{regularization parameter to guarantee asymptotic control of the false discovery rate; should be a small positive value, but rho = 0 works well in most simulations}

\item{m}{search for the optimal threshold up to only the mth largest unique value of T; can speed up computation}

\item{rescale}{apply rank transformation to the test statistics within each sequence such that they are of comparable scales}
}
\value{
indices of the features delcared to be simultaneous signals
}
\description{
Given D sequences of test statistics, returns the optimal square rejection that identifies the largest number of simultaneous signals while controlling the false discovery rate. Assumes a common threshold for each sequence.
}
\examples{
\donttest{
## generate paired test statistics
p <- 10^6; ## total number of pairs
X <- c(rep(0,p-30),rep(1,10),rep(2,10),rep(3,10));
## X=0: no signal in either sequence of tests
## X=1: signal in sequence 1 only
## X=2: signal in sequence 2 only
## X=3: simultaneous signal
set.seed(1);
Z1 <- rnorm(p,0,1); Z1[X==1|X==3] <- rnorm(20,3,1);
Z2 <- rnorm(p,0,1); Z2[X==2|X==3] <- rnorm(20,4,1);
T <- cbind(Z1^2, Z2^2);
## rejected simultaneous signals
nfsdr(T, 0.05)
}

}
