% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_name_plots.R
\name{name_plot_censored}
\alias{name_plot_censored}
\title{Graphical representation of named toxicity censored data}
\usage{
name_plot_censored(data, p, leftNA = 0, rightNA = Inf)
}
\arguments{
\item{data}{A data.frame with column \code{conc} if uncensored data, with
\code{left} and \code{right} if censored data. In any case, must contain a
column \code{name}.}

\item{p}{A ggplot object showing the empirical cumulative distribution
function of the censored data provided.}

\item{leftNA}{The value to replace censored left values. Default to 0 because
toxicity values are concentrations.}

\item{rightNA}{The value to replace censored right values.}
}
\value{
A ggplot object.
}
\description{
Add names to a provided empirical cumulative distribution function ggplot
(i.e.,species names).
}
\details{
The positions of the names on the plot are based on the raw data
visualization and not the non parametric maximum likelihood estimation
(NPMLE) representation, but they can be added to both types of plot.

Compatible with plots colored by group labels.
}
