% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hc.R
\name{ssd_hc}
\alias{ssd_hc}
\alias{ssd_hc.list}
\alias{ssd_hc.fitdists}
\alias{ssd_hc.fitburrlioz}
\title{Hazard Concentrations for Species Sensitivity Distributions}
\usage{
ssd_hc(x, ...)

\method{ssd_hc}{list}(x, percent, proportion = 0.05, ...)

\method{ssd_hc}{fitdists}(
  x,
  percent = deprecated(),
  proportion = 0.05,
  ...,
  average = TRUE,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  multi_est = deprecated(),
  est_method = "multi",
  ci_method = "weighted_samples",
  parametric = TRUE,
  delta = 9.21,
  samples = FALSE,
  save_to = NULL,
  control = NULL
)

\method{ssd_hc}{fitburrlioz}(
  x,
  percent,
  proportion = 0.05,
  ...,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  parametric = FALSE,
  samples = FALSE,
  save_to = NULL
)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{percent}{A numeric vector of percent values to estimate hazard concentrations for. Deprecated for \code{proportion = 0.05}. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{proportion}{A numeric vector of proportion values to estimate hazard concentrations for.}

\item{average}{A flag specifying whether to provide model averaged values as opposed to a value for each distribution.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level of the interval.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the confidence limits. A value of 10,000 is recommended for official guidelines.}

\item{min_pboot}{A number between 0 and 1 of the minimum
proportion of bootstrap samples that must successfully fit (return a likelihood)
to report the confidence intervals.}

\item{multi_est}{A flag specifying whether to estimate directly from
the model-averaged cumulative distribution function (\code{multi_est = TRUE}) or
to take the arithmetic mean of the estimates from the
individual cumulative distribution functions weighted
by the AICc derived weights  (\code{multi_est = FALSE}).}

\item{est_method}{A string specifying whether to estimate directly from
the model-averaged cumulative distribution function (\code{est_method = 'multi'}) or
to take the arithmetic mean of the estimates from the
individual cumulative distribution functions weighted
by the AICc derived weights  (\code{est_method = 'arithmetic'}) or
or to use the geometric mean instead (\code{est_method = 'geometric'}).}

\item{ci_method}{A string specifying which method to use for estimating
the standard error and confidence limits from the bootstrap samples.
Possible values include \code{ci_method = "multi_fixed"} and  \code{ci_method = "multi_free"}
which generate the bootstrap samples using the model-averaged cumulative distribution function
but differ in whether the model weights are fixed at the values for the original dataset
or re-estimated for each bootstrap sample dataset.
The value \code{ci_method = "weighted_samples"} takes bootstrap samples
from each distribution proportional to its AICc based weights and
calculates the confidence limits (and SE) from this single set.
The value \code{ci_method = "MACL"} (was \code{ci_method = "weighted_arithmetic"} but
has been soft-deprecated) which is only included for
historical reasons takes the weighted arithmetic mean of the confidence
limits.}

\item{parametric}{A flag specifying whether to perform parametric bootstrapping as opposed to non-parametrically resampling the original data with replacement.}

\item{delta}{A non-negative number specifying the maximum absolute AIC difference cutoff.
Distributions with an absolute AIC difference greater than delta are excluded from the calculations.}

\item{samples}{A flag specfying whether to include a numeric vector of the bootstrap samples as a list column in the output.}

\item{save_to}{NULL or a string specifying a directory to save where the bootstrap datasets and parameter estimates (when successfully converged) to.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}
}
\value{
A tibble of corresponding hazard concentrations.
}
\description{
Calculates concentration(s) with bootstrap confidence intervals
that protect specified proportion(s) of species for
individual or model-averaged distributions
using parametric or non-parametric bootstrapping.
}
\details{
Model-averaged estimates and/or confidence intervals (including standard error)
can be calculated  by treating the distributions as
constituting a single mixture distribution
versus 'taking the mean'.
When calculating the model averaged estimates treating the
distributions as constituting a single mixture distribution
ensures that \code{ssd_hc()} is the inverse of \code{ssd_hp()}.

Distributions with an absolute AIC difference greater
than a delta of by default 7 have considerably less support (wt < 0.01)
and are excluded
prior to calculation of the hazard concentrations to reduce the run time.
}
\section{Methods (by class)}{
\itemize{
\item \code{ssd_hc(list)}: Hazard Concentrations for Distributional Estimates

\item \code{ssd_hc(fitdists)}: Hazard Concentrations for fitdists Object

\item \code{ssd_hc(fitburrlioz)}: Hazard Concentrations for fitburrlioz Object

}}
\examples{

ssd_hc(ssd_match_moments())

fits <- ssd_fit_dists(ssddata::ccme_boron)
ssd_hc(fits)

fit <- ssd_fit_burrlioz(ssddata::ccme_boron)
ssd_hc(fit)
}
\references{
Burnham, K.P., and Anderson, D.R. 2002. Model Selection and Multimodel Inference. Springer New York, New York, NY. doi:10.1007/b97636.
}
\seealso{
\code{\link[=predict.fitdists]{predict.fitdists()}} and \code{\link[=ssd_hp]{ssd_hp()}}.
}
