% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scp.R
\name{scp}
\alias{scp}
\alias{scp_download}
\alias{scp_upload}
\title{SCP (Secure Copy)}
\usage{
scp_download(session, files, to = ".", verbose = TRUE)

scp_upload(session, files, to = ".", verbose = TRUE)
}
\arguments{
\item{session}{ssh connection created with \code{\link[=ssh_connect]{ssh_connect()}}}

\item{files}{path to files or directory to transfer}

\item{to}{existing directory on the destination where \code{files} will be copied into}

\item{verbose}{print progress while copying files}
}
\description{
Upload and download files to/from the SSH server via the scp protocol.
Directories in the \code{files} argument are automatically traversed and
uploaded / downloaded recursively.
}
\details{
Note that the syntax is slightly different from the \code{scp} command line
tool because the \code{to} parameter is always a target \emph{directory} where
all \code{files} will be copied \strong{into}. If \code{to} does not exist, it will be
created.

The \code{files} parameter in \code{\link[=scp_upload]{scp_upload()}} is vectorised hence all files
and directories will be recursively uploaded \strong{into} the \code{to} directory.
For \code{\link[=scp_download]{scp_download()}} the \code{files} parameter must be a single string which
may contain wildcards.

The default path \code{to = "."} means that files get downloaded to the current
working directory and uploaded to the user home directory on the server.
}
\examples{
\dontrun{
# recursively upload files and directories
session <- ssh_connect("dev.opencpu.org")
files <- c(R.home("doc"), R.home("COPYING"))
scp_upload(session, files, to = "~/target")

# download it back
scp_download(session, "~/target/*", to = tempdir())

# delete it from the server
ssh_exec_wait(session, command = "rm -Rf ~/target")
}
}
\seealso{
Other ssh: \code{\link{ssh_connect}},
  \code{\link{ssh_exec}}, \code{\link{ssh_tunnel}}
}
