% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{github}
\alias{github}
\alias{gh}
\alias{github_api}
\alias{rate_limit}
\title{Make calls to the github API}
\usage{
gh(path, proxy_url = NULL)

github_api(path, proxy_url = NULL)

rate_limit(proxy_url = NULL)
}
\arguments{
\item{path}{Character string with path to the API resource.}

\item{proxy_url}{Character string defining a network proxy in the form
host:port. Default is NULL in which case the API call will not use a proxy.}
}
\value{
A list of class github_api containing the parsed content, API
resource path and the response object. For \code{rate_limit()} the path is
always "/rate_limit" and can hence be used to detect if the limit is exceeded
(without being counted as a request itself). If the allowed API rate is
exceeded \code{gh()} will return a message stating the fact and simple
suggestions on how to remedy the problem.
}
\description{
Provides a structured list of the specified resource from the the github API.
}
\details{
For most use cases only \code{gh()} will be relevant. The helper function
\code{github_api()} do the actual lifting while \code{rate_limit()} handles
API rate limits.
}
\examples{
## Get all branches of a repository. If the api rate limit is exceeded this
## function will return NULL and an informative message
gh("repos/Rapporteket/sship/branches")

## helper functions that will normally not be used
github_api("/rate_limit")
rate_limit()
}
