% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_formula.R, R/spm_smooth.R
\name{map_formula}
\alias{map_formula}
\alias{map_formula,sf,ANY,formula-method}
\alias{spm_smooth,ANY,missing,ANY-method}
\alias{spm_smooth,ANY,ANY,missing-method}
\alias{spm_smooth,ANY,ANY,sspm_boundary-method}
\title{Map model formula onto a sspm_dataset object}
\usage{
map_formula(data_frame, boundaries, formula, time, ...)

\S4method{map_formula}{sf,ANY,formula}(data_frame, boundaries, formula, time, ...)

\S4method{spm_smooth}{ANY,missing,ANY}(
  sspm_object,
  formula,
  boundaries,
  keep_fit = TRUE,
  predict = TRUE,
  ...
)

\S4method{spm_smooth}{ANY,ANY,missing}(
  sspm_object,
  formula,
  boundaries,
  keep_fit = TRUE,
  predict = TRUE,
  ...
)

\S4method{spm_smooth}{ANY,ANY,sspm_boundary}(
  sspm_object,
  formula,
  boundaries,
  keep_fit = TRUE,
  predict = TRUE,
  ...
)
}
\arguments{
\item{data_frame}{\strong{[sf data.frame]} The data.}

\item{boundaries}{\strong{[sspm_boundary]} An object of class
\link[=sspm_boundary-class]{sspm_discrete_boundary}.}

\item{formula}{\strong{[formula]} A formula definition of the form
response ~ smoothing_terms + ...}

\item{time}{\strong{[character]} The time column.}

\item{...}{ a list of variables that are the covariates that this
    smooth is a function of. Transformations whose form depends on
    the values of the data are best avoided here: e.g. \code{s(log(x))}
    is fine, but \code{s(I(x/sd(x)))} is not (see \code{\link[mgcv]{predict.gam}}).}

\item{sspm_object}{\strong{[sspm_dataset]} An object of class
\link[=sspm_dataset-class]{sspm_dataset}.}

\item{keep_fit}{\strong{[logical]} Whether or not to keep the fitted values and
model (default to TRUE, set to FALSE to reduce memory footprint).}

\item{predict}{\strong{[logical]} Whether or not to generate the smoothed
predictions (necessary to fit the final SPM model, default to TRUE).}
}
\value{
The updated object.
}
\description{
This functions is now used internally to map a formula onto a \code{sspm_dataset}
or \code{sspm} object.
}
\examples{
\dontrun{
map_formula(data_frame = all_data, boundaries = boundaries,
            formula = formula, time = time, ...)
}
}
\keyword{internal}
