% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sspse.R
\name{plot.sspse}
\alias{plot.sspse}
\title{Plot Summary and Diagnostics for Population Size Estimation Model Fits}
\usage{
\method{plot}{sspse}(
  x,
  xlim = NULL,
  support = 1000,
  HPD.level = 0.9,
  N = NULL,
  ylim = NULL,
  mcmc = FALSE,
  type = "all",
  main = "Posterior for population size",
  smooth = 4,
  include.tree = TRUE,
  cex.main = 1,
  log.degree = "",
  layout = c(3, 2),
  method = "bgk",
  ...
)
}
\arguments{
\item{x}{an object of class \code{"plot.sspse"}, usually, a result of a call
to \code{plot.sspse}.}

\item{xlim}{the (optional) x limits (x1, x2) of the plot of the posterior of
the population size.}

\item{support}{the number of equally-spaced points to use for the support of
the estimated posterior density function.}

\item{HPD.level}{numeric; probability level of the highest probability
density interval determined from the estimated posterior.}

\item{N}{Optionally, an estimate of the population size to mark on the plots
as a reference point.}

\item{ylim}{the (optional) vertical limits (y1, y2) of the plot of the
posterior of the population size. A vertical axis is the probability density
scale.}

\item{mcmc}{logical; If TRUE, additionally create simple diagnostic plots
for the MCMC sampled statistics produced from the fit.}

\item{type}{character; This controls the types of plots produced.  If
\code{"N"}, a density plot of the posterior for population size is produced.
and the prior for population size is overlaid. If \code{"summary"}, a 
density plot of the posterior for mean visibility in the population and
a plot of the posterior for standard deviation of the visibility in the population.
If \code{"visibility"}, a density plot of
the visibility distribution (its posterior mean) and the same plot with the 
with visibilities of those in the sample overlaid.
If \code{"degree"}, a scatter plot of the visibilities verses the reported network sizes for 
those in the sample.
If \code{"prior"}, a density plot of the prior for population size is produced.
If \code{"all"}, then all plots for \code{"N"}, \code{"summary"}, \code{"visibility"} and
\code{"degree"} are produced.
In all cases the visibilities are estimated (by their posterior means).}

\item{main}{an overall title for the posterior plot.}

\item{smooth}{the (optional) smoothing parameter for the density estimate.}

\item{include.tree}{logical; If \code{TRUE}, 
augment the reported network size by the number of recruits and one for the recruiter (if any).
This reflects a more accurate value for the visibility, but is not the reported degree.
In particular, it typically produces a positive visibility (compared to a possibility zero reported degree).}

\item{cex.main}{an overall title for the posterior plot.}

\item{log.degree}{a character string which contains \code{"x"} if the (horizontal) degree axis in the plot
of the estimated visibilites for each respondent verses their reported network sizes be logarithmic. 
A value of \code{"y"} uses a logarithmic visibility axis and \code{"xy"} both. The default is \code{""}, no logarithmic axes.}

\item{layout}{a vector of the form ‘c(nv, nc)’. The produced plots, in particular the MCMC diagnostics, will be draw in 
figures in ‘nv’-by-‘nc’ arrays per page. `nc` is typically 2 to have the trace plots on the left and density plots on the right.
`nv` is then the number of variables per page, by default 3.}

\item{method}{character; The method to use for density estimation (default Gaussian Kernel; "bgk").
"Bayes" uses a Bayesian density estimator which has good properties.}

\item{\dots}{further arguments passed to or from other methods.}
}
\description{
This is the \code{plot} method for class \code{"sspse"}. Objects of
this class encapsulate the 
estimate of the posterior distribution of the
population size based on data collected by Respondent Driven Sampling. The
approach approximates the RDS via the Sequential Sampling model of Gile
(2008).  As such, it is referred to as the Sequential Sampling - Population Size Estimate (SS-PSE).
It uses the order of selection of the sample to provide information
on the distribution of network sizes over the population members.
}
\details{
By default it produces a density plot of the posterior for population size
and the prior for population size is overlaid. It also produces a
density plot of the posterior for mean network size in the population, the
posterior for standard deviation of the network size, and a density plot of
the posterior mean network size distribution with sample histogram overlaid.
}
\examples{

data(fauxmadrona)
# Here interval=1 so that it will run faster. It should be higher in a 
# real application.
fit <- posteriorsize(fauxmadrona, median.prior.size=1000,
                                 burnin=20, interval=1, samplesize=100)
summary(fit)
# Let's look at some MCMC diagnostics
plot(fit, mcmc=TRUE)

}
\references{
Gile, Krista J. (2008) \emph{Inference from Partially-Observed Network
Data}, Ph.D. Thesis, Department of Statistics, University of Washington.

Gile, Krista J. and Handcock, Mark S. (2010) \emph{Respondent-Driven
Sampling: An Assessment of Current Methodology}, Sociological Methodology
40, 285-327.

Gile, Krista J. and Handcock, Mark S. (2014) \pkg{sspse}: Estimating Hidden 
Population Size using Respondent Driven Sampling Data
R package, Los Angeles, CA.  Version 0.5, \url{https://hpmrg.org/sspse/}.

Handcock MS (2003).  \pkg{degreenet}: Models for Skewed Count Distributions
Relevant to Networks.  Statnet Project, Seattle, WA.  Version 1.2,
\url{https://statnet.org/}.

Handcock, Mark S., Gile, Krista J. and Mar, Corinne M. (2014)
\emph{Estimating Hidden Population Size using Respondent-Driven Sampling
Data}, Electronic Journal of Statistics, 8, 1, 1491-1521

Handcock, Mark S., Gile, Krista J. and Mar, Corinne M. (2015)
\emph{Estimating the Size of Populations at High Risk for HIV using Respondent-Driven 
Sampling Data}, Biometrics.
}
\seealso{
The model fitting function \code{\link{posteriorsize}},
\code{\link[graphics]{plot}}.

Function \code{\link[stats]{coef}} will extract the matrix of coefficients with
standard errors, t-statistics and p-values.
}
\keyword{hplot}
