% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpr_tools.R
\name{cpr_dob}
\alias{cpr_dob}
\title{Extracting date of birth from CPR}
\usage{
cpr_dob(cpr, format = "\%d-\%m-\%Y")
}
\arguments{
\item{cpr}{cpr-numbers as ddmmyy"-."xxxx or ddmmyyxxxx.
Also mixed formatting. Vector or data frame column.}

\item{format}{character string of dob date format. Default is "\%d-\%m-\%Y".}
}
\value{
character vector
}
\description{
For easy calculation. Does not handle cprs with letters (interim cpr)
}
\examples{
cpr_dob("231045-0637")
fsd<-c("2310450637", "010190-2000", "010115-4000",
"300450-1030","010150-4021")
cpr_dob(fsd)
}
\keyword{cpr}
