% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorption_functions.R
\name{abs_fit_slope}
\alias{abs_fit_slope}
\title{Fit absorbance data to exponential curve. \code{\link[drc]{drm}} is used for the fitting process.}
\usage{
abs_fit_slope(wl, abs, lim, l_ref = 350, control = drmc(errorm = FALSE,
  noMessage = TRUE), ...)
}
\arguments{
\item{wl}{vector containing wavelengths}

\item{abs}{vector containing absorption in m^-1}

\item{lim}{vector containing lower and upper limits for wavelengths to use}

\item{l_ref}{numerical. reference wavelength, default is 350, if set to NA l_ref is fitted}

\item{control}{control parameters for drm, see \code{\link[drc]{drmc}}}

\item{...}{parameters that are passed on to drm}
}
\value{
numeric exponential slope coefficient
}
\description{
Fit absorbance data to exponential curve. \code{\link[drc]{drm}} is used for the fitting process.
}
\examples{
data(abs_data)
abs_fit_slope(abs_data$wavelength,abs_data$sample1,lim=c(350,400),l_ref=350)
}
\seealso{
\code{\link[drc]{drm}}
}
