% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorption_functions.R
\name{absorbance_read}
\alias{absorbance_read}
\title{Reading absorbance data from txt and csv files.}
\usage{
absorbance_read(absorbance_path, order = TRUE, recursive = TRUE,
  dec = NULL, ...)
}
\arguments{
\item{absorbance_path}{directory containing absorbance data files or path to single file. See details for format of absorbance data.}

\item{order}{logical, data is ordered according to wavelength}

\item{recursive}{read files recursive, include subfolders}

\item{dec}{optional, either you set a decimal separator or the table is tested for . and ,}

\item{...}{additional arguments that are passed on to \code{\link[data.table]{fread}}.}
}
\value{
A data frame containing absorbance data. An attribute "location" contains the filenames where each sample was taken from.
}
\description{
Reading absorbance data from txt and csv files.
}
\details{
If absorbance_path is a directory, contained files that end on "csv" or "txt" are passed on to \code{read.table}. If the path goes to a file, this file is passed on. Tables can either contain data from one sample or from several samples in columns. The column header containig the wavelength must be either "wavelength" or "Wavelength". A multi-sample file must have sample names as column names. A single-sample file can have sample name as column name or sample name as file name and "Abs." as column name. All tables are combined to one with one wavelength column and one column for each sample containing the absorbance data.
}
\examples{
absorbance_path <- system.file("extdata", "absorbance_eemR", package = "staRdom")
absorbance_read(absorbance_path)
}
\seealso{
\code{\link[data.table]{fread}}
}
