% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_anova.R
\name{add_anova}
\alias{add_anova}
\alias{add_anova.default}
\title{Additive ANOVA for Genotypes by Environment Interaction (GEI) model}
\usage{
add_anova(.data, .y, .rep, .gen, .env)

\method{add_anova}{default}(.data, .y, .rep, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.rep}{Replication Factor}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Additive ANOVA
}
\description{
Additive ANOVA for Genotypes by Environment Interaction (GEI) model
}
\examples{
data(ge_data)
YieldANOVA <-
     add_anova(
            .data = ge_data
          , .y    = Yield
          , .rep  = Rep
          , .gen  = Gen
          , .env  = Env
      )
YieldANOVA

}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
Muhammad Yaseen (\email{myaseen208@gmail.com})
}
