% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ge_means.R
\name{ge_means}
\alias{ge_means}
\alias{ge_means.default}
\title{Genotype by Environment Interaction Means and Ranks}
\usage{
ge_means(.data, .y, .gen, .env)

\method{ge_means}{default}(.data, .y, .gen, .env)
}
\arguments{
\item{.data}{data.frame}

\item{.y}{Response Variable}

\item{.gen}{Genotypes Factor}

\item{.env}{Environment Factor}
}
\value{
Means and Ranks
}
\description{
Calcuates Genotype by Environment Interaction Means along with their Ranks
}
\examples{

data(ge_data)

Yield.ge_means <-
          ge_means(
                .data  = ge_data
               , .y    = Yield
               , .gen  = Gen
               , .env  = Env
               )

Yield.ge_means$ge_means
Yield.ge_means$ge_ranks
Yield.ge_means$g_means
Yield.ge_means$e_means


}
\references{
Singh, R. K. and Chaudhary, B. D. (2004) \emph{Biometrical Methods in Quantitative Genetic Analysis}.
             New Delhi: Kalyani.
}
\author{
\enumerate{
         \item Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item Kent M. Edkridge (\email{keskridge1@unl.edu})
         }
}
