% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-inference-functions.R
\name{prob.sevt}
\alias{prob.sevt}
\title{Compute probabilities for a staged event tree}
\usage{
prob.sevt(object, x, log = FALSE, nan0 = TRUE)
}
\arguments{
\item{object}{a (fitted) staged event tree object}

\item{x}{the vector or data.frame of observations}

\item{log}{logical, if \code{TRUE} log-probabilities are returned}

\item{nan0}{logical, if \code{NaN} should be converted to 0}
}
\value{
the probabilities to observe each observation given in \code{x}
}
\description{
Compute probabilities for a staged event tree
}
\details{
it computes probabilities related to a vector or a data.frame of observations.
They can be as an \code{expand.grid} data.frame or a simple subset of the dataset on which
the model is estimated.
}
\examples{
DD <- generate_random_dataset(5, 100)
model <- staged_ev_tree(DD, fit = TRUE, lambda = 1)
pr <- prob.sevt(model, expand.grid(model$tree[c(2, 3, 4)]))
sum(pr)
prob.sevt(model, DD[1:10, ])
}
