% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamp.group.summary.r
\name{stamp.group.summary}
\alias{stamp.group.summary}
\title{Compile stamp summary statistics by group}
\usage{
stamp.group.summary(stmp, area = TRUE, count = TRUE)
}
\arguments{
\item{stmp}{a \code{SpatialPolygonsDataFrame} generated from the \code{stamp} function.}

\item{area}{logical, whether or not to compute the STAMP event areas.}

\item{count}{logical, whether or not to compute the count of STAMP evets within each group.}
}
\value{
A \code{data.frame} where rows are stamp groups and columns correspond to the STAMP event types (ID, areas, and counts).
}
\description{
The function \code{stamp.group.summary} compiles summary statistics for each STAMP grouping.
 Specifically, it computes the area of each STAMP event type (e.g., generation, expansion, etc.)
 within each grouping. It also computes the number of events belonging to each event type.
}
\details{
\code{stamp.group.summary} computes area and count summary statistics of STAMP output. Note that if
 both \code{area} and \code{count} are set to \code{FALSE}, \code{stamp.group.summary} returns a
 \code{data.frame} with just the group IDs as the only column.
}
\keyword{stamp}

