% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.matching.R
\name{moments.matching}
\alias{moments.matching}
\title{Moments of the generalised matching distribution}
\usage{
moments.matching(size, trials = 1, prob = 0, include.sd = FALSE)
}
\arguments{
\item{size}{The size parameter for the generalised matching distribution (number of objects to match)}

\item{trials}{The trials parameter for the generalised matching distribution (number of times the matching game is repeated)}

\item{prob}{The probability parameter for the generalised matching distribution (probability of known match)}

\item{include.sd}{Logical value; if \code{TRUE} the output includes the standard deviation}
}
\value{
If all inputs are correctly specified (i.e., parameters are in allowable range) then the output will be
a data frame of moments
}
\description{
\code{moments.match} returns some representative moments from the distribution.
}
\details{
This function computes some representative moments from the generalised matching distribution.
Further details on the distribution can be found in the following paper:

O'Neill, B. (2021) A generalised matching distribution for the problem of coincidences.
}
\examples{
moments.matching(5)
}
