% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{anogva}
\alias{anogva}
\title{ANOGVA Analysis Of Graph Variability}
\usage{
anogva(graphs, labels, numBoot = 1000, bandwidth = "Silverman")
}
\arguments{
\item{graphs}{a list of adjacency (symmetric) matrices of undirected graphs.
For unweighted graphs, each matrix contains only 0s and 1s. For weighted
graphs, each matrix may contain real values that correspond to the weights of
the edges.}

\item{labels}{an array of integers indicating the labels of each graph.}

\item{numBoot}{integer indicating the number of bootstrap resamplings.}

\item{bandwidth}{string indicating which criterion will be used to choose
the bandwidth for the spectral density estimation. The available criteria are
"Silverman" (default) and "Sturges".}
}
\value{
A list containing:
\item{statistic}{the statistic of the test.}
\item{p.value}{the p-value of the test.}
}
\description{
\code{anogva} statistically tests whether two or more sets of graphs are generated
by the same random graph model. It is a generalization of the 'graph.test'
function.
}
\examples{

require(igraph)
g1 <- g2 <- g3 <- list()
for (i in 1:20) {
   G1 <- erdos.renyi.game(50, 0.50)
   g1[[i]] <- get.adjacency(G1)
   G2 <- erdos.renyi.game(50, 0.50)
   g2[[i]] <- get.adjacency(G2)
   G3 <- erdos.renyi.game(50, 0.52)
   g3[[i]] <- get.adjacency(G3)
}
g <- c(g1, g2, g3)
label <- c(rep(1,20),rep(2,20),rep(3,20))
result <- anogva(g, label, numBoot=50)
result

}
\references{
Fujita, A., Vidal, M. C. and Takahashi, D. Y. (2017) A Statistical Method to
Distinguish Functional Brain Networks. \emph{Front. Neurosci.}, \emph{11}, 66.
doi:10.3389/fnins.2017.00066.

Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. \emph{PLoS ONE}, \emph{7}, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) \emph{Density Estimation}.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. \emph{J. Am. Statist. Assoc.},
\emph{21}, 65-66.
}
\keyword{analysis_of_graph_variability}
