% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{anogva}
\alias{anogva}
\title{ANOGVA Analysis Of Graph Variability}
\usage{
anogva(G, labels, maxBoot = 1000, bandwidth = "Silverman")
}
\arguments{
\item{G}{a list of undirected graphs (igraph type) or their adjacency
matrices. The adjacency matrix of an unweighted graph contains only 0s and
1s, while the weighted graph may have nonnegative real values that correspond
to the weights of the edges.}

\item{labels}{an array of integers indicating the labels of each graph.}

\item{maxBoot}{integer indicating the number of bootstrap resamplings.}

\item{bandwidth}{string showing which criterion is used to choose the
bandwidth during the spectral density estimation. Choose between the
following criteria: "Silverman" (default), "Sturges", "bcv", "ucv" and "SJ".
"bcv" is an abbreviation of biased cross-validation, while "ucv" means
unbiased cross-validation. "SJ"  implements the methods of Sheather & Jones
(1991) to select the bandwidth using pilot estimation of derivatives.}
}
\value{
A list containing:
\item{statistic}{the statistic of the test.}
\item{p.value}{the p-value of the test.}
}
\description{
\code{anogva} statistically tests whether two or more sets of graphs are generated
by the same random graph model. It is a generalization of the 'takahashi.test'
function.
}
\examples{
set.seed(1)
g1 <- g2 <- g3 <- list()
for (i in 1:20) {
  g1[[i]] <- igraph::sample_gnp(50, 0.50)
  g2[[i]] <- igraph::sample_gnp(50, 0.50)
  g3[[i]] <- igraph::sample_gnp(50, 0.52)
}
G <- c(g1, g2, g3)
label <- c(rep(1,20),rep(2,20),rep(3,20))
result <- anogva(G, label, maxBoot=50)
result

}
\references{
Fujita, A., Vidal, M. C. and Takahashi, D. Y. (2017) A Statistical Method to
Distinguish Functional Brain Networks. _Front. Neurosci._, *11*, 66.
doi:10.3389/fnins.2017.00066.

Takahashi, D. Y., Sato, J. R., Ferreira, C. E. and Fujita A. (2012)
Discriminating Different Classes of Biological Networks by Analyzing the
Graph Spectra  Distribution. _PLoS ONE_, *7*, e49949.
doi:10.1371/journal.pone.0049949.

Silverman, B. W. (1986) _Density Estimation_.  London: Chapman and Hall.

Sturges, H. A. The Choice of a Class Interval. _J. Am. Statist. Assoc._,
*21*, 65-66.

Sheather, S. J. and Jones, M. C. (1991). A reliable data-based bandwidth
selection method for kernel density estimation.
_Journal of the Royal Statistical Society series B_, 53, 683-690.
http://www.jstor.org/stable/2345597.
}
\keyword{analysis_of_graph_variability}
