% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSL.R
\name{SSL}
\alias{SSL}
\alias{L4.fun}
\alias{L3.fun}
\alias{L2.fun}
\alias{NLS.L4}
\alias{NLS.L3}
\alias{NLS.L2}
\alias{DRC.L2}
\title{Logistic equations}
\usage{
L4.fun(predictor, b, c, d, e)
L3.fun(predictor, b, d, e)
L2.fun(predictor, b, e)
NLS.L4(predictor, b, c, d, e)
NLS.L3(predictor, b, d, e)
NLS.L2(predictor, b, e)
DRC.L2(upper = 1, fixed = c(NA, NA), names = c("b", "e"))
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model}

\item{b}{model parameter (slope at inflection point)}

\item{c}{model parameter (lower asymptote)}

\item{d}{model parameter (higher asymptote)}

\item{e}{model parameter (abscissa at inflection point)}

\item{upper}{numeric. For L.2, a upper asymptote different from 1 can be specified.}

\item{fixed}{numeric vector. Specifies which parameters are fixed and at what value they are fixed. NAs for parameter that are not fixed.}

\item{names}{names. A vector of character strings giving the names of the parameters. The default is reasonable.}
}
\value{
L4.fun, L3.fun, L2.fun, NLS.L4, NLS.L3 and NLS.L2 return a numeric value,
while DRC.L2 returns a list containing the nonlinear function, the self starter function
and the parameter names.
}
\description{
These functions provide the logistic equations with 4 (L4.fun), 3 (L3.fun)
and 2 (L2.fun) parameters with self-starter for the \code{\link{nls}}
function (NLS.L4, NLS.L3 and NLS.L2) and the self-starter for logistic
function with two parameters for the \code{\link[drc]{drm}} function in the
drc package (DRC.L2).
}
\details{
The logistic equation is parameterised as:
\deqn{ f(x) = c + \frac{d - c}{1+exp\left[-b(x - e)\right]} }
for the 3- and 2-parameter model c is equal to 0, while for the 2-parameter model
d is equal to 1.
}
\examples{
data(beetGrowth)
mod3 <- nls(weightInf ~ NLS.L3(DAE, b, c, d), data = beetGrowth)
mod3b <- drm(weightInf ~ DAE, fct=DRC.L2(upper = 25), data = beetGrowth)
}
\author{
Andrea Onofri
}
