% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{countValidPlot}
\alias{countValidPlot}
\title{Count valid observations per plotId for a given trait}
\usage{
countValidPlot(TP, trait, plotIds = NULL)
}
\arguments{
\item{TP}{An object of class TP.}

\item{trait}{A character string indicating the trait for which valid
observations should be counted.}

\item{plotIds}{A character vector indicating the plotIds for which valid
observations should be checked. If \code{NULL} valid observations are
counted for all plotIds in TP.}
}
\value{
A named numerical vector with he number of valid observations per
plotId.
}
\description{
Count valid observations per plotId for a given trait.
}
\examples{
## Create a TP object containing the data from the Phenovator.
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3", "check4"))
## Count valid observations for EffpsII for a subset of plots.
countValidPlot(phenoTP,
               trait = "EffpsII",
               plotIds = c("c12r22", "c24r41", "c14r32"))

}
