% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcIBDMPP.R
\name{calcIBDMPP}
\alias{calcIBDMPP}
\title{IBD calculation for multi parental populations}
\usage{
calcIBDMPP(
  crossNames,
  markerFiles,
  pheno,
  popType,
  mapFile,
  evalDist,
  grid = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{crossNames}{A character vector, the names of the crosses.}

\item{markerFiles}{A character vector indicating the locations of the files
with genotypic information for the populations. The files should be in
tab-delimited format with a header containing marker names.}

\item{pheno}{A data.frame or a list of data.frames with phenotypic data,
with genotypes in the first column \code{genotype} and traits in the
following columns. The trait columns should be numerical columns only.
A list of data.frames can be used for replications, i.e. different
trials.}

\item{popType}{A character string indicating the type of population. One of
DH, Fx, FxDH, BCx, BCxDH, BC1Sx, BC1SxDH, C3, C3DH, C3Sx, C3SxDH, C4, C4DH,
C4Sx, C4SxDH (see Details).}

\item{mapFile}{A character string indicating the location of the map file
for the population. The file should be in tab-delimited format. It should
consist of exactly three columns, marker, chromosome and position. There
should be no header. The positions in the file should be in centimorgan.}

\item{evalDist}{A numeric value, the maximum distance in cM between
evaluation points.}

\item{grid}{Should the extra markers that are added to assure the a
maximum distince of \code{evalDist} be on a grid (\code{TRUE}) or in between
marker existing marker positions (\code{FALSE}).}

\item{verbose}{Should progress be printed?}
}
\value{
An object of class \code{gDataMPP} with the following components:
\item{\code{map}}{a data.frame containing map data. Map is sorted by
chromosome and position.}
\item{\code{markers}}{a 3D matrix containing IBD probabilities.}
\item{\code{pheno}}{data.frame or list of data.frames containing phenotypic
data.}
\item{\code{kinship}}{a kinship matrix.}
\item{\code{covar}}{a data.frame with extra covariates (including the
name of the cross).}
}
\description{
IBD calculation for multi parental populations. Per cross IBD probabilities
are calculated using \code{calcIBD} in the statgenIBD package. These
probabilities are combined with optional phenotypic data and stored in a
single object of class \code{gDataMPP}.
}
\details{
IBD probabilities can be calculated for many different types of populations.
In the following table all supported populations are listed. Note that the
value of x in the population types is variable, with its maximum value
depicted in the last column.\tabular{llll}{
   \strong{Population type} \tab \strong{Cross} \tab \strong{Description} \tab \strong{max. x} \cr
   DH \tab biparental \tab doubled haploid population \tab  \cr
   Fx \tab biparental \tab Fx population (F1, followed by x-1 generations of selfing) \tab 8 \cr
   FxDH \tab biparental \tab Fx, followed by DH generation \tab 8 \cr
   BCx \tab biparental \tab backcross, second parent is recurrent parent \tab 9 \cr
   BCxDH \tab biparental \tab BCx, followed by DH generation \tab 9 \cr
   BC1Sx \tab biparental \tab BC1, followed by x generations of selfing \tab 7 \cr
   BC1SxDH \tab biparental \tab BC1, followed by x generations of selfing and DH \tab 6 \cr
   C3 \tab three-way \tab three way cross: (AxB) x C \tab  \cr
   C3DH \tab three-way \tab C3, followed by DH generation \tab  \cr
   C3Sx \tab three-way \tab C3, followed by x generations of selfing \tab 7 \cr
   C3SxDH \tab three-way \tab C3, followed by x generations of selfing and DH generation \tab 6 \cr
   C4 \tab four-way \tab four-way cross: (AxB) x (CxD) \tab  \cr
   C4DH \tab four-way \tab C4, followed by DH generation \tab  \cr
   C4Sx \tab four-way \tab C4, followed by x generations of selfing \tab 6 \cr
   C4SxDH \tab four-way \tab C4, followed by x generations of selfing and DH generation \tab 6 \cr
}
}
\examples{
## Read phenotypic data.
pheno <- read.delim(system.file("extdata/multipop", "AxBxCpheno.txt",
                               package = "statgenMPP"))
## Rename first column to genotype.
colnames(pheno)[1] <- "genotype"


## Compute IBD probabilities for simulated population - AxB, AxC.
ABC <- calcIBDMPP(crossNames = c("AxB", "AxC"),
                  markerFiles = c(system.file("extdata/multipop", "AxB.txt",
                                              package = "statgenMPP"),
                                  system.file("extdata/multipop", "AxC.txt",
                                              package = "statgenMPP")),
                  pheno = pheno,
                  popType = "F4DH",
                  mapFile = system.file("extdata/multipop", "mapfile.txt",
                                        package = "statgenMPP"),
                  evalDist = 5)

summary(ABC)

}
