% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runme.R
\name{rmd2pdf}
\alias{rmd2pdf}
\title{Convert Rmd to PDF}
\usage{
rmd2pdf(fn = NULL, wd = NULL, ..., verbose = FALSE, purl = TRUE,
  tangle = purl, backup = TRUE)
}
\arguments{
\item{fn}{One or more filenames ending in "*.Rmd".}

\item{wd}{A working directory in which the Rmd file exists. Leave
as NULL if file is in current working directory,}

\item{...}{Arguments that will be passed to \code{rmarkdown::render} and
\code{rmarkdown::pdf_document}. Our defaults set a LaTeX template, toc =
TRUE, and the pandoc_args includes use of the listings class.
Users may override by specifying named arguments for
\code{render()}: \code{c("output_file", "output_dir",
"output_options", "intermediates_dir", "knit_root_dir",
"runtime", "clean", "params", "knit_meta", "envir",
"run_pandoc", "quiet", "encoding")}. Users may also specify
named arguments for \code{pdf_document:} \code{("toc",
"toc_depth", "number_sections", "fig_width", "fig_height",
"fig_crop", "fig_caption", "dev", "df_print", "highlight",
"template", "keep_tex", "latex_engine", "citation_package",
"includes", "md_extensions", "pandoc_args",
"extra_dependencies")}.}

\item{verbose}{The opposite of render(quiet = TRUE). Shows compile
commentary and pandoc command. Can be informative!}

\item{purl}{Default TRUE}

\item{tangle}{Default TRUE, synonym for purl}

\item{backup}{Default TRUE. Will create backup copies of pdf, R, Rnw
files before replacing them. Uses \code{kutils::file.backup}}
}
\value{
A vector of output file names
}
\description{
Convert an Rmd file to PDF by Sweaveing or knitting and then compiling.
}
\details{
Running this will be the same as running the rmd2pdf.sh script
within the directory.
}
\examples{
tdir <- tempdir()
fmt <- "rmd2pdf-guide"
dirout <- initWriteup(fmt, dir = file.path(tdir, fmt))
print(dirout)
list.files(dirout)
\donttest{
of1 <- try(rmd2pdf("skeleton.Rmd", wd = dirout))
if(inherits(of1, "try-error")){
    MESSG <- paste("Compiling the markdown file failed, perhaps",
                  "you should run with parameters verbose=TRUE",
                  "and keep_tex=TRUE")
    print(MESSG)
} else {
    ## Check the result file:
    MESSG <- paste("Check the directory", dirout, "for results.")
    print(MESSG)
    list.files(dirout)
    if(interactive() && file.exists(file.path(dirout, "skeleton.pdf"))) {
        browseURL(of1)
    }
}
}
unlink(dirout)
}
\author{
Paul Johnson <pauljohn@ku.edu>
}
