% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop2.inv}
\alias{ci.prop2.inv}
\title{Confidence interval for a 2-group proportion difference using inverse
sampling}
\usage{
ci.prop2.inv(alpha, f1, f2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f1}{number of participants in group 1 who have the attribute}

\item{f2}{number of participants in group 2 who have the attribute}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of proportion difference
\item SE - recovered standard error
\item LL - lower limit of confidence interval
\item UL - upper limit of confidence interval
}
}
\description{
Computes an approximate confidence interval for a population proportion
difference when inverse sampling has been used. An approximate standard
error is recovered from the confidence interval. With inverse sampling, the
number of participants who have the attribute within group 1 (f1) and group 2
(f2) are predetermined, and sampling continues within each group until f1
and f2 attain their prespecified values. With inverse sampling, the sample
sizes (n1 and n2) will not be known in advance.
}
\examples{
ci.prop2.inv(.05, 10, 10, 48, 213)

# Should return:
#  Estimate         SE         LL        UL
#  0.161385 0.05997618 0.05288277 0.2879851


}
\references{
\insertRef{Zou2010}{statpsych}
}
