% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.lc.reg}
\alias{ci.lc.reg}
\title{Confidence interval for a linear contrast of regression coefficients in
multiple group regression model}
\usage{
ci.lc.reg(alpha, est, se, n, s, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{est}{vector of parameter estimates}

\item{se}{vector of standard errors}

\item{n}{vector of group sample sizes}

\item{s}{number of predictor variables for each within-group model}

\item{v}{vector of contrast coefficients}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated linear contrast
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - two-sided p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval and test statistic for a linear contrast
of population regression coefficients (e.g., a y-intercept or a slope
coefficient) across groups in a multiple group regression model. Equality
of error variances across groups is not assumed. A Satterthwaite adjustment
to the degrees of freedom is used to improve the accuracy of the confidence
interval.
}
\examples{
est <- c(1.74, 1.83, 0.482)
se <- c(.483, .421, .395)
n <- c(40, 40, 40)
v <- c(.5, .5, -1)
ci.lc.reg(.05, est, se, n, 4, v)

# Should return:
# Estimate        SE        t      df          p        LL       UL
#    1.303 0.5085838 2.562016 78.8197 0.01231256 0.2906532 2.315347
 

}
