% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.test.slope.gen}
\alias{size.test.slope.gen}
\title{Sample size for a slope hypothesis test in a general statistical model}
\usage{
size.test.slope.gen(alpha, pow, se, n0, b)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{pow}{desired power}

\item{se}{standard error of slope from prior/pilot study}

\item{n0}{sample size used in prior/pilot study}

\item{b}{planning value of population slope}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to test a null hypothesis with desired
power that a population slope coefficient in any general statistical model
is equal to zero. This function requires a standard error estimate for the
slope of interest from a prior or pilot study and the sample size that was
used in the prior or pilot study. This function can be used for both
unstandardized and standardized slopes. This function also can be used for
both unstandardized and standardized factor loadings in a confirmatory
factor analysis model. This function will soon be replaced with size.test.gen.
}
\examples{
size.test.slope.gen(.05, .8, 3.15, 50, 5)

# Should return:
#  Sample size
#          156
 

}
