% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dl.R
\name{dl_stats19}
\alias{dl_stats19}
\title{Download STATS19 data for a year}
\usage{
dl_stats19(
  year = NULL,
  type = NULL,
  data_dir = get_data_directory(),
  file_name = NULL,
  ask = FALSE,
  silent = FALSE
)
}
\arguments{
\item{year}{A year matching file names on the STATS19
\href{https://www.data.gov.uk/dataset/cb7ae6f0-4be6-4935-9277-47e5ce24a11f/road-safety-data}{data release page}
e.g. \code{2020}}

\item{type}{One of 'Accident', 'Casualty', 'Vehicle'; defaults to 'Accident'.
Or any variation of to search the file names with such as "collision".}

\item{data_dir}{Parent directory for all downloaded files. Defaults to \code{tempdir()}.}

\item{file_name}{The file name (DfT named) to download.}

\item{ask}{Should you be asked whether or not to download the files? \code{TRUE} by default.}

\item{silent}{Boolean. If \code{FALSE} (default value), display useful progress
messages on the screen.}
}
\description{
Download STATS19 data for a year
}
\section{Details}{

This function downloads and unzips UK road crash data.
It results in unzipped .csv files that are put
in the temporary directory specified by \code{get_data_directory()} or provided \code{data_dir}.

The file downloaded would be for a specific year (e.g. 2022).
It could also be a file containing data for a range of two (e.g. 2005-2014).

The \verb{dl_*} functions can download many MB of data so ensure you
have a sufficient internet access and hard disk space.
}

\examples{
\donttest{
if(curl::has_internet()) {
# type by default is accidents table
dl_stats19(year = 2022)
# try another year
dl_stats19(year = 2018)
}
}
}
\seealso{
\code{\link[=get_stats19]{get_stats19()}}
}
