% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_corr_test_expressions.R
\name{expr_corr_test}
\alias{expr_corr_test}
\title{Making expression for correlation analysis}
\usage{
expr_corr_test(
  data,
  x,
  y,
  beta = 0.1,
  type = "parametric",
  bf.prior = 0.707,
  conf.level = 0.95,
  k = 2L,
  stat.title = NULL,
  ...
)
}
\arguments{
\item{data}{for use with \code{formula}, a data frame containing all the
data}

\item{x}{The column in \code{data} containing the explanatory variable to be
plotted on the \code{x}-axis. Can be entered either as a character string (e.g.,
\code{"x"}) or as a bare expression (e.g, \code{x}).}

\item{y}{The column in \code{data} containing the response (outcome) variable to
be plotted on the \code{y}-axis. Can be entered either as a character string
(e.g., \code{"y"}) or as a bare expression (e.g, \code{y}).}

\item{beta}{bending constant (Default: \code{0.1}). For more, see \code{?WRS2::pbcor}.}

\item{type}{Type of association between paired samples required
("\code{"parametric"}: Pearson's product moment correlation coefficient" or
"\code{"nonparametric"}: Spearman's rho" or "\code{"robust"}: percentage bend
correlation coefficient" or "\code{"bayes"}: Bayes Factor for Pearson's \emph{r}").
Corresponding abbreviations are also accepted: \code{"p"} (for
parametric/pearson), \code{"np"} (nonparametric/spearman), \code{"r"} (robust),
\code{"bf"} (for bayes factor), resp.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{...}{Additional arguments (ignored).}
}
\value{
Expression containing results from correlation test with confidence
intervals for the correlation coefficient estimate.
}
\description{
Making expression for correlation analysis
}
\examples{

# for reproducibility
set.seed(123)

# without changing defaults
statsExpressions::expr_corr_test(
  data = ggplot2::midwest,
  x = area,
  y = percblack,
  type = "parametric"
)

# changing defaults
statsExpressions::expr_corr_test(
  data = ggplot2::midwest,
  x = area,
  y = percblack,
  beta = 0.2,
  type = "robust"
)
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
