% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plothour.r
\name{phour}
\alias{phour}
\title{Hour rose plot. Copied and modified from the openair package.
\code{phour()} plotted a 24-hour clock, indicating the active hours on the basis of a time column in a data frame. It is highly cumstomized on the basis of the \code{openair::windrose()} function`.}
\usage{
phour(my_df = NA, col_time = "created", ws = "ws", wd = "hour360", ws2 = NA, wd2 = NA, 
    ws.int = 30, angle = 1, type = "default", cols = "default", grid.line = NULL, 
    width = 1, seg = 0.9, auto.text = TRUE, breaks = 4, offset = 10, paddle = FALSE, 
    key.header = NULL, key.footer = "(SBD)", key.position = "right", key = FALSE, 
    dig.lab = 5, statistic = "prop.count", pollutant = NULL, cust_labels = c(0, 6, 
        12, 18), annotate = FALSE, border = NA, quantile_line = TRUE, ...)
}
\arguments{
\item{my_df}{A data frame containing the fields ws and wd.}

\item{col_time}{the column name for the time stamp}

\item{ws}{A character string of the name of the column representing the radium of the circular sectors in the diagram. It can be SBD payout, votes, comments, etc..}

\item{wd}{A character sring of the name of the column representing the hour of the day.}

\item{ws2}{The user can supply a second set of data with which the first can be compared.}

\item{wd2}{see ws2.}

\item{ws.int}{A numeric vector of the ws interval. Default is 2.}

\item{angle}{The hour spokes. Other potentially useful angle is 3 (hours).}

\item{type}{type determines how the data are split i.e. conditioned, and then plotted.  It can be 'season', 'year', 'weekday'...  The default is will produce a single plot using the entire data. It can also be a numeric or factor vector.}

\item{cols}{Colours for plotting.  'default', 'increment', 'heat', 'jet', 'hue' and user defined, such as c("yellow", "green", "blue", "black").}

\item{grid.line}{Grid line interval. NULL in default.It can also be a numeric value like 10, or a list like list(value = 10, lty = 5, col = "purple").}

\item{width}{The adjustment factor for width of payout intervals. For example, width = 1.5 will make the paddle width 1.5 times wider. For paddle = TRUE.}

\item{seg}{The width of the segments. 0.5 will produce segments 0.5 * angle.}

\item{auto.text}{A logical value of whether formatting the names and units automatically in the titles and axis labels}

\item{breaks}{A numeric vector of the number of break points for payouts. 4 by default, which generates the break points 2, 4, 6, 8 SBD for ws.int default of 2 SBD. It can also be c(0, 1, 10, 100), which breaks the data into segments <1, 1-10, 10-100, >100.}

\item{offset}{A numeric value (default 10) of the size of the 'hole' in the middle of the plot, expressed as a percentage of the polar axis scale.}

\item{paddle}{A logic value. TRUE means the 'paddle' style spokes, and FALSE means the 'wedge' style spokes.}

\item{key.header}{A character string of additional text above the scale key.}

\item{key.footer}{A character string of additional text below the scale key.}

\item{key.position}{A character string of the location of the scale key. 'top', 'right', 'bottom' and 'left'.}

\item{key}{Fine control of the scale key}

\item{dig.lab}{A numeric value of the signficant digits at which scientific number formatting is used in break point.}

\item{statistic}{A character string of the statistic to be applied.
\itemize{
\item 'prop.count' (default) sizes bins according to the proportion of the frequency of the records,
\item 'prop.mean' sizes bins according to their relative contribution to the mean,
\item 'abs.count' provides the absolute count of records in each bin.
}}

\item{pollutant}{Alternative data series to be sampled.}

\item{cust_labels}{A numeric vector displayed as the customed labels}

\item{annotate}{A logic value or a character string.
\itemize{
\item TRUE: the percentage calm and mean values are printed in each panel together with a description of the statistic below the plot.
\item " ": only the stastic is below the plot.
\item Custom annotations may be added by setting value to c("annotation 1", "annotation 2").
}}

\item{border}{A character string of the border colour for shaded areas.}

\item{quantile_line}{whether to display the quantile line}

\item{...}{other parameters}
}
\value{
A figure with the active hour rose
}
\description{
Hour rose plot. Copied and modified from the openair package.
\code{phour()} plotted a 24-hour clock, indicating the active hours on the basis of a time column in a data frame. It is highly cumstomized on the basis of the \code{openair::windrose()} function`.
}
\examples{
\dontrun{
phour()
}
}
