% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAssets.R
\name{getAssets}
\alias{getAssets}
\title{Returns all assets.}
\usage{
getAssets(cursor = NULL, asset_code = NULL, asset_issuer = NULL,
  limit = 10, order = "asc", data.table = TRUE)
}
\arguments{
\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{asset_code}{character - (optional) code of the asset to filter by}

\item{asset_issuer}{character - (optional) issuer of the asset to filter by}

\item{limit}{numeric - optional, the number of records to return. Default is 10.}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}
}
\value{
list
}
\description{
Return all assets in the system with statistics.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/assets-all.html
}
\examples{
getAssets(limit = 10)
}
