% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd-fakeTSCS.R
\docType{data}
\name{fakeTSCS}
\alias{fakeTSCS}
\title{Fake Data for a Time-Series Cross-Section}
\format{
A data frame with 2500 observations on the following 8 variables.
\describe{
\item{\code{year}}{a numeric vector for the year}
\item{\code{country}}{a character vector for the country}
\item{\code{y}}{a numeric vector for the outcome.}
\item{\code{x1}}{a continuous variable}
\item{\code{x2}}{a binary variable}
\item{\code{base}}{a numeric vector for the baseline starting point for each country}
\item{\code{growth_units}}{a numeric vector for the growth units for each country}
\item{\code{growth_error}}{a numeric vector for the growth errors for each country}
}
}
\usage{
fakeTSCS
}
\description{
This is a toy (i.e. "fake") data set created by the \code{fabricatr} package.
 There are 100 observations for 25 hypothetical countries. The outcome \code{y}
 is a linear function of a baseline for each hypothetical country, plus a yearly
 growth trend as well as varying growth errors for each country. \code{x1} is
 supposed to have a linear effect of .5 on \code{y}, all things considered.
 \code{x2} is supposed to have a linear effect of 1 on \code{y} for each unit
 change in \code{x2}, all things considered.
}
\details{
\code{x1} is generated by a normal distribution with a mean of 5 and a standard
deviation of 2. \code{x2} is drawn from a Bernoulli distribution with a
probability of .5 of observing a 1.
}
\keyword{datasets}
