% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_bma.R
\name{do_bma}
\alias{do_bma}
\title{Undertake undertake coefficient averaging using Bayesian Model Avergaing (BMA), weighting different models by their probabilities}
\usage{
do_bma(model_table, terms, thresh = 0.1, relative = FALSE, input_data)
}
\arguments{
\item{model_table}{a table of competing models generated by the \code{gam_model_probs()} function}

\item{terms}{a vector of names starting with "Intercept" plus the names of the covariates used in the GAM model (these are the names of the variables in  \code{data} )}

\item{thresh}{a probability threshold value above which to combine competing models}

\item{relative}{logical to indicate whether the probabilities in \code{data} are relative (\code{Pr(M)}) or absolute (\code{Pr(M|D)})}

\item{input_data}{the input data with a named Intercept term, in \code{data.frame}, \code{tibble} or \code{sf} format}
}
\value{
A \code{matrix} of the probability weighted averaged coefficient estimates from multiple models.
}
\description{
Undertake undertake coefficient averaging using Bayesian Model Avergaing (BMA), weighting different models by their probabilities
}
\examples{
library(cols4all)
library(dplyr)
library(sf)
library(glue)
library(purrr)
library(mgcv)
library(sf)
library(ggplot2)
# data
data(productivity)
input_data = productivity |> filter(year == "1970") |> mutate(Intercept = 1)
# create and evaluate multiple models
svc_res_gam = evaluate_models(input_data, STVC = FALSE)
# determine their probabilities
mod_comp_svc <- gam_model_probs(svc_res_gam)
# combine the model coefficients
svc_bma <- do_bma(mod_comp_svc,
                  terms = c("Intercept", "unemp", "pubC"),
                  thresh = 0.1,
                  relative = FALSE,
                  input_data = input_data)
head(svc_bma)
# join back to spatial layer
data(us_data)
svc_bma_sf <-
us_data |>
select(GEOID) |>
left_join(productivity |>
  filter(year == "1970") |>
  select(GEOID, year) |>
  cbind(svc_bma)) |>
  relocate(geometry, .after = last_col())
# and map
tit =expression(paste(""*beta[`Public Capital`]*" "))
ggplot(data = svc_bma_sf, aes(fill=pubC)) +
  geom_sf() +
  scale_fill_continuous_c4a_div(palette="brewer.yl_or_rd",name=tit) +
  coord_sf() +
  theme_linedraw()
}
