% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rthin.stlpp.R
\name{rthin.stlpp}
\alias{rthin.stlpp}
\title{Random thinning}
\usage{
\method{rthin}{stlpp}(X, P = P, nsim = 1)
}
\arguments{
\item{X}{a spatio-temporal point pattern of class \code{\link{stlpp}}}

\item{P}{retention probability}

\item{nsim}{number of simulated realisations to be generated}
}
\value{
An object of the same kind as X if nsim=1, or a list of such objects if nsim > 1.
}
\description{
This function applies independent random thinning to a spatio-temporal point pattern on a linear network.
}
\details{
See \code{\link{rthin}}.
}
\examples{
 
data(Medellin)
rthin(Medellin,P=.5)

}
\references{
Moradi, M., & Mateu, J. (2020). First-and second-order characteristics of spatio-temporal point processes on linear networks. Journal of Computational and Graphical Statistics, 29(3), 432-443.
}
\seealso{
\code{\link{stlpp}}, \code{\link{rthin}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
