% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stoRy_cache.R
\name{stoRy_cache}
\alias{stoRy_cache}
\alias{stoRy_cache_path}
\alias{stoRy_cache_details}
\alias{delete_lto_version_cached_files}
\alias{delete_stoRy_cached_files}
\alias{delete_all_cached_stoRy_files}
\alias{print_stoRy_cache_info}
\title{Manage cached files}
\usage{
stoRy_cache_path()

stoRy_cache_details()

delete_lto_version_cached_files(version, force = TRUE, verbose = TRUE)

delete_stoRy_cached_files(files, force = TRUE)

delete_all_cached_stoRy_files(force = TRUE)

print_stoRy_cache_info()
}
\arguments{
\item{version}{A length-one character vector specifying an LTO version tag.
Set to "latest" to configure the latest numbered version, and "dev" to
configure the LTO developmental version.}

\item{force}{Set to TRUE to force delete files.}

\item{verbose}{A logical value indicating whether status messages should be
output to console.}

\item{files}{A list of file path strings to delete from cache.}
}
\description{
Manage \pkg{stoRy} package cached files.

\code{stoRy_cache_path()} returns the file path where \pkg{stoRy} package files
are cached.

\code{stoRy_cache_details()} returns a tibble of cached file names with
accompanying metadata. File size is in MB.

\code{delete_lto_version_cached_files()} delete cached files associated with an
\acronym{LTO} version.

\code{delete_stoRy_cached_files()} delete cached files. Takes a vector of file
path strings as input.

\code{delete_all_cached_stoRy_files()} clear cache.

\code{print_stoRy_cache_info()} print to console cache contents.
}
\examples{
\dontrun{
# list files in cache
stoRy_list_cached_files()

# List info for all files
print_stoRy_cache_info()

# delete all files in cache
# stoRy_delete_all_cached_files()
}
}
